// == content.js (v8 - JDTSS SPA 兼容 + 特征检测版) ==
// 功能：自动监听反馈抽屉“发送”按钮 + 在交流历史注入“推送选中方案”按钮
// ============ 核心事件处理器 ============


let hasBoundListener = false;//防重全局锁
let hasInjectedButton = false;
//let hasInjectedTableFeature = false;

// === 全局高亮样式（只注入一次）===
(function injectGlobalHighlightStyle() {
  if (document.getElementById('dtss-row-highlight-style')) return;
  const style = document.createElement('style');
  style.id = 'dtss-row-highlight-style';
  style.textContent = `
    .dtss2002-selected-row {
      background-color: #e6f7ff !important;
    }
    .dtss2002-selected-row td,
    .dtss2002-selected-row th {
      border-bottom: 2px solid #1890ff !important;
      padding-bottom: 3px !important;
    }
  `;
  document.head.appendChild(style);
})();

// === Toast 提示 ===
function showTemporaryToast(message, type = 'info') {
  let container = document.getElementById('dtss-toast-container');
  if (!container) {
    container = document.createElement('div');
    container.id = 'dtss-toast-container';
    container.style.cssText = `
      position: fixed; top: 20px; right: 20px; z-index: 2147483647; pointer-events: none;
    `;
    document.body.appendChild(container);
  }

  const toast = document.createElement('div');
  toast.textContent = message;
  toast.style.cssText = `
    padding: 8px 12px; margin: 4px 0; 
    background: ${type === 'success' ? '#07c160' : type === 'error' ? '#fa5151' : '#1890ff'};
    color: white; border-radius: 4px; font-size: 12px;
    box-shadow: 0 2px 8px rgba(0,0,0,0.2);
    animation: dtssFadeInOut 4s ease-in-out forwards;
  `;

  if (!document.getElementById('dtss-toast-style')) {
    const style = document.createElement('style');
    style.id = 'dtss-toast-style';
    style.textContent = `
      @keyframes dtssFadeInOut {
        0%   { opacity: 0; transform: translateY(-10px); }
        10%  { opacity: 1; transform: translateY(0); }
        90%  { opacity: 1; transform: translateY(0); }
        100% { opacity: 0; transform: translateY(-10px); }
      }
    `;
    document.head.appendChild(style);
  }

  container.appendChild(toast);
  setTimeout(() => toast.remove(), 4000);
}

// ================= 主监听：抽屉出现 =================
function startObserving() {
  setInterval(() => {
    const drawers = document.querySelectorAll('.el-drawer');
    //console.log('[JDTSS Debug] 检测到', drawers.length, '个 .el-drawer');

    for (const drawer of drawers) {
      // 如果还没绑定，就尝试绑定
      if (!drawer.__dtssBound__) {
        //console.log('[JDTSS Debug] ⚠️ 尝试绑定未处理的抽屉');
        bindIfNotAlready(drawer);
      }
    }
  }, 800); // 足够频繁，但不过度
}
/*
function startObserving() {
  const observer = new MutationObserver((mutations) => {
    for (const mutation of mutations) {
      if (mutation.type === 'attributes') {
        const target = mutation.target;
        if (
          target.nodeType === 1 &&
          (target.classList?.contains('el-drawer') || target.hasAttribute('aria-label'))
        ) {
          if (isDrawerVisible(target)) {
            bindIfNotAlready(target);
          }
        }
      }
    }
  });

  observer.observe(document.body, {
    childList: true,
    subtree: true,
    attributes: true,
    attributeFilter: ['class', 'style', 'hidden']
  });
*/
  // === 轮询兜底（持续监听抽屉）===
  const pollInterval = setInterval(() => {
  const drawers = document.querySelectorAll('.el-drawer');
  // 可选：在生产环境可注释掉下面这行以减少日志
  //console.log(`[JDTSS Debug] 检测到 ${drawers.length} 个 .el-drawer`);

	  for (const drawer of drawers) {
		const isVisible = isDrawerVisible(drawer);
		const fullText = (drawer.textContent || '').replace(/\s+/g, ' ');
		// console.log(`[JDTSS Debug] 抽屉可见: ${isVisible}, 文本预览: "${fullText.substring(0, 150)}..."`);

		if (isVisible && !drawer.__dtssBound__) {
		  //console.log('[JDTSS Debug] ⚠️ 尝试绑定未处理的抽屉');
		  bindIfNotAlready(drawer);
		}
	  }
	  // 注意：不再 clearInterval，保持持续监听以支持多次开关抽屉
	}, 1000);

 
function injectSyncCheckbox(drawer) {
    //console.log('[JDTSS] 💡 尝试注入复选框，当前 drawer:', drawer);
  //if (drawer.__dtssCheckboxInjected__) return;
  // 每次都尝试注入，但先检查是否已存在
	if (drawer.querySelector('#dtss-sync-checkbox')) {
	    //console.log('[JDTSS] ⚠️ 复选框已存在，跳过');
	  return; // 已存在，不重复注入
	}

  let retryCount = 0;
  const maxRetries = 15;

  function tryInject() {
    // 找到底部按钮区域（根据你提供的结构）
    const footer = drawer.querySelector('[style*="position: absolute"][style*="bottom: 0px"]');
    if (!footer) {
      if (++retryCount < maxRetries) {
        setTimeout(tryInject, 200);
      }
      return;
    }

    // 找到所有 primary 按钮
    const buttons = footer.querySelectorAll('button.el-button--primary');
    let sendButton = null;

    for (const btn of buttons) {
      const span = btn.querySelector('span');
      if (span && /发\s*送/.test(span.textContent)) {
        sendButton = btn;
        break;
      }
    }

    if (!sendButton) {
      if (++retryCount < maxRetries) {
        setTimeout(tryInject, 200);
      }
      return;
    }

    // 防止重复注入
    if (sendButton.__dtssCheckboxInjected__) return;
    sendButton.__dtssCheckboxInjected__ = true;

    // 创建复选框容器
    const container = document.createElement('div');
    container.style.cssText = `
      display: inline-flex;
      align-items: center;
      margin-left: 12px;
      font-size: 12px;
      color: #606266;
      vertical-align: middle;
    `;

    const checkbox = document.createElement('input');
    checkbox.type = 'checkbox';
    checkbox.id = 'dtss-sync-checkbox';
    checkbox.style.marginRight = '4px';

    const label = document.createElement('label');
    label.htmlFor = 'dtss-sync-checkbox';
    label.textContent = '同步推送至企微';

    container.appendChild(checkbox);
    container.appendChild(label);

    // 插入到 footer 中，放在所有按钮之后
    footer.appendChild(container);

    drawer.__dtssCheckboxInjected__ = true;
    console.log('[JDTSS] ✅ 成功注入“同步推送”复选框');
  }

  tryInject();
}

 

function isDrawerVisible(el) {
  //if (hasBoundListener || drawer.__dtssBound__) return;
  if (!el || el.nodeType !== 1) return false;
  const style = window.getComputedStyle(el);
  if (style.display === 'none' || style.visibility === 'hidden' || el.hidden) return false;
  if (el.classList.contains('el-drawer__open') || el.classList.contains('is-open')) return true;
  const rect = el.getBoundingClientRect();
  return rect.width > 0 && rect.height > 0;
}

/*
function bindIfNotAlready(drawer) {
  if (hasBoundListener || drawer.__dtssBound__) return;
  const titleText = (drawer.textContent || '').replace(/\s+/g, '');
  if (!titleText.includes('创建反馈单')) return;

  drawer.__dtssBound__ = true;
  hasBoundListener = true;
  showTemporaryToast('监听页面“发送”按钮...', 'info');
  attachSendButtonListener(drawer); // ✅ 唯一正确的调用
}
*/
//增加草稿编辑弹窗功能，服用发送按键逻辑
function bindIfNotAlready(drawer) {
  const titleText = (drawer.textContent || '').replace(/\s+/g, '');
  let mode = null;
  if (titleText.includes('创建反馈单')) {
    mode = 'create';
  } else if (titleText.includes('编辑草稿')) {
    mode = 'edit';
  } else {
    return;
  }

  // === 1. 复选框：每次都尝试安全注入（内部防重）===
  if (mode === 'edit') {
    injectSyncCheckbox(drawer);
  }

  // === 2. 事件监听：只绑定一次（用标记防重）===
  if (!drawer.__dtssEventListenerBound__) {
    attachSendButtonListener(drawer, mode);
    drawer.__dtssEventListenerBound__ = true; // 仅用于监听器
  }
}

// === 新增函数：监听表单是否被清空（视为新打开）===
function setupResetDetector(drawer) {
  // 选择关键字段（根据你的表单结构）
  const watchFields = [
    '#bodyNr input',   // VIN
    '#carnum input',   // 车牌
    '#khms textarea',  // 故障描述
    '#scname input'    // 服务顾问
  ].map(selector => drawer.querySelector(selector)).filter(Boolean);

  if (watchFields.length === 0) return;

  // 记录初始状态（避免刚打开就误判）
  let isFirstCheck = true;
  let previousValues = watchFields.map(f => f.value || f.getAttribute('title') || '');

  const observer = new MutationObserver(() => {
    const currentValues = watchFields.map(f => f.value || f.getAttribute('title') || '');

    // 首次检查：记录初始值
    if (isFirstCheck) {
      previousValues = currentValues;
      isFirstCheck = false;
      return;
    }

    // 检查是否所有字段都被清空（典型的新建/重置行为）
    const allEmptyNow = currentValues.every(v => v.trim() === '');
    const wasNotEmptyBefore = previousValues.some(v => v.trim() !== '');

    if (allEmptyNow && wasNotEmptyBefore) {
      console.log('[JDTSS] 检测到表单被清空，视为抽屉重新打开');
      // 清除标记，允许重新绑定
      delete drawer.__dtssBound__;
      delete drawer.__dtssCheckboxInjected__;
      observer.disconnect();
      return;
    }

    // 更新历史值
    previousValues = currentValues;
  });

  // 监听属性变化（如 title）和子节点变化（如 value）
  watchFields.forEach(field => {
    observer.observe(field, { attributes: true, childList: true, subtree: true });
  });

  // 防止内存泄漏：5秒后停止观察（足够覆盖打开后操作）
  setTimeout(() => observer.disconnect(), 5000);
}

/*
function attachSendButtonListener(drawer) {
  console.log('attachSendButtonListener运行');
  let hasBoundToButton = false;

  function tryBindButton() {
    const buttons = drawer.querySelectorAll('button.el-button--primary');
    for (const btn of buttons) {
      if (btn.__dtssSendBound__) continue;
      const text = (btn.textContent || '').replace(/\s+/g, '');
      if (/^(发?送|Send)$/i.test(text)) {
        btn.__dtssSendBound__ = true;
        hasBoundToButton = true;

        btn.addEventListener('click', () => {
          const data = extractFormDataFromDrawer(drawer);
          const hasContent = data.vin || data.advisor || data.plate || data.partNo || data.faultDesc;
          if (!hasContent) {
            showTemporaryToast('⚠️ 表单为空', 'error');
            return;
          }

          chrome.runtime.sendMessage({ action: "sendTableMessage", data }, (response) => {
            if (response?.success) {
              showTemporaryToast('✅ 已提交，请在企微群确认', 'success');
            } else if (response?.error === 'MISSING_WEBHOOK') {
              showTemporaryToast('⚠️ 请先配置 Webhook 地址', 'warning');
            } else {
              showTemporaryToast('❌ 提交失败，请重试', 'error');
              console.error("推送失败:", response?.error);
            }
          });
        });

        console.log('[JDTSS] 成功绑定“发送”按钮:', btn);
        
        return true;
      }
    }
    return false;
  }

  if (tryBindButton()) return;

  const observer = new MutationObserver((mutations) => {
    if (hasBoundToButton) return;
    if (tryBindButton()) {
      observer.disconnect();
    }
  });

  observer.observe(drawer, { childList: true, subtree: true });
  setTimeout(() => observer.disconnect(), 2000);
}
*/
function attachSendButtonListener(drawer, mode = 'create') {
  const handleClick = (e) => {
    const button = e.target.closest('button.el-button--primary');
    if (!button) return;

    const buttonText = (button.textContent || '').replace(/\s+/g, '');
    if (buttonText !== '发送') return;

    // ===== 新增：编辑模式下检查复选框 =====
    if (mode === 'edit') {
      const checkbox = drawer.querySelector('#dtss-sync-checkbox');
      if (!checkbox || !checkbox.checked) {
        console.log('[JDTSS] 编辑草稿模式，未勾选同步，跳过推送');
        return; // 不推送，但允许原页面发送
      }
    }

    // ===== 提取数据 =====
    const data = extractFormDataFromDrawer(drawer);
    const hasContent = data.vin || data.advisor || data.plate || data.partNo || data.faultDesc;
    if (!hasContent) {
      showTemporaryToast('⚠️ 表单为空', 'error');
      return;
    }

    // ===== 发送 =====
    chrome.runtime.sendMessage({ action: "sendTableMessage", data }, (response) => {
      if (chrome.runtime.lastError) {
        console.error('[JDTSS] 推送失败:', chrome.runtime.lastError);
        showTemporaryToast('❌ 推送失败：通信错误', 'error');
      } else if (response?.success) {
        showTemporaryToast('✅ 已推送至企微群', 'success');
      } else {
        showTemporaryToast('❌ 推送失败，请重试', 'error');
      }
    });
  };

  drawer.addEventListener('click', handleClick, true);
}

// ================= 表单数据提取 =================
function extractFormDataFromDrawer(drawer) {
  const vin = drawer.querySelector('#bodyNr input')?.getAttribute('title')?.trim() || '';
  const plate = drawer.querySelector('#carnum input')?.value?.trim() || '';
  const faultDesc = drawer.querySelector('#khms textarea')?.value?.trim() || '';
  const advisor = getServiceAdvisor();

  return { vin, plate, faultDesc, advisor };
}

function getServiceAdvisor() {
  const input = document.querySelector('#scname input');
  return input ? (input.value?.trim() || '') : '';
}

// ================= 交流历史：注入“推送选中方案”按钮 =================

function isCommunicationDrawer(node) {
  return node.id === 'download' ||
         node.classList.contains('wrapper') ||
         !!node.querySelector('#communication-history-table');
}

function injectPushButton(drawer) {
  if (drawer.__dtss2002_injected__) return;
  
  let attempts = 0;
  const maxAttempts = 10;
  
  function tryInject() {
    const historySection = drawer.querySelector('#common-row-08');
    if (historySection && historySection.querySelector('.v-table-toper')) {
      drawer.__dtss2002_injected__ = true;
      doInject(historySection.querySelector('.v-table-body') || historySection, historySection);
    } else if (++attempts < maxAttempts) {
      setTimeout(tryInject, 400);
    }
  }
  
  tryInject();
}

let selectedRow = null;

function doInject(rowsContainer, historySection) {
  const actionsBar = historySection.querySelector('.v-table-toper > .v-actions');
  if (!actionsBar || actionsBar.__dtssHasButton__) return;
  actionsBar.__dtssHasButton__ = true;

  let solutionColumnIndex = -1;
  const allTh = historySection.querySelectorAll('th');

  allTh.forEach((th, index) => {
    const rawText = th.textContent || '';
    // 清洗：去空白 + 去掉排序相关文字
    const cleanText = rawText
      .replace(/\s+/g, '')
      .replace(/排序|升序|降序|Sort|ASC|DESC/i, '');

    if (/发送信息|解决方案|回复内容|交流内容/.test(cleanText)) {
      solutionColumnIndex = index;
    }
  });

  if (solutionColumnIndex === -1) {
    console.warn('[JDTSS] 未找到“发送信息”等列，回退到第5列');
    solutionColumnIndex = 4;
  }
  
  const btn = document.createElement('button');
  btn.textContent = '📤 推送选中方案';
  Object.assign(btn.style, {
    background: '#1890ff',
    color: 'white',
    border: 'none',
    borderRadius: '4px',
    padding: '4px 10px',
    fontSize: '12px',
    marginLeft: '8px',
    cursor: 'pointer',
    verticalAlign: 'middle'
  });

  btn.onclick = () => {
    if (!selectedRow) {
      showTemporaryToast('⚠️ 请先点击一行选择处理方案', 'error');
      return;
    }

    const cells = selectedRow.querySelectorAll('td.v-body--column');
    const targetCell = cells[solutionColumnIndex];
    let selectedMessage = '';

    if (targetCell) {
      selectedMessage = targetCell.querySelector('.v-cell')?.textContent?.trim() ||
                        targetCell.textContent?.trim() ||
                        '';
    }

    if (!selectedMessage) {
      showTemporaryToast('❌ 未获取到处理方案内容', 'error');
      return;
    }

    const data = {
      vin: document.querySelector('#bodyNr input')?.getAttribute('title')?.trim() || '',
      plate: document.querySelector('#carnum input')?.value?.trim() || '',
      faultDesc: document.querySelector('#khms textarea')?.value?.trim() || '',
      advisor: getServiceAdvisor(),
      selectedMessage
    };

    showConfirmDialog(data, (finalMessage) => {
      const finalData = { ...data, selectedMessage: finalMessage };
      chrome.runtime.sendMessage({ action: 'sendManualTableMessage', data: finalData }, (res) => {
        if (chrome.runtime.lastError) {
          console.error('sendMessage error:', chrome.runtime.lastError);
          showTemporaryToast('❌ 推送失败：通信错误', 'error');
        } else if (res?.success) {
          showTemporaryToast('✅ 已成功推送', 'success');
        } else {
          showTemporaryToast('❌ 推送失败', 'error');
        }
      });
    });
  };

  actionsBar.appendChild(btn);

  let rowsObserver = null;
  let retryCount = 0;
  const maxRetries = 15;

  function tryBindRowClicks() {
    const rows = Array.from(rowsContainer.querySelectorAll('tr.v-body--row'));
    if (rows.length > 0) {
      rowsContainer.querySelectorAll('.dtss2002-selected-row').forEach(r => r.classList.remove('dtss2002-selected-row'));

      rows.forEach(row => {
        if (!row.__dtssClickBound__) {
          row.__dtssClickBound__ = true;
          row.style.cursor = 'pointer';
          row.addEventListener('click', () => {
            rows.forEach(r => r.classList.remove('dtss2002-selected-row'));
            selectedRow = row;
            row.classList.add('dtss2002-selected-row');
          });
        }
      });

      if (rowsObserver) rowsObserver.disconnect();
      return true;
    } else if (++retryCount < maxRetries) {
      setTimeout(tryBindRowClicks, 400);
      return false;
    } else {
      console.warn('[JDTSS] 未能找到交流历史表格行');
      return false;
    }
  }

  if (!tryBindRowClicks()) {
    rowsObserver = new MutationObserver((mutations) => {
      for (const m of mutations) {
        if (m.type === 'childList' && m.target === rowsContainer) {
          if (tryBindRowClicks()) {
            rowsObserver.disconnect();
            break;
          }
        }
      }
    });
    rowsObserver.observe(rowsContainer, { childList: true, subtree: true });
  }
}

// ================= 监听抽屉出现（交流历史）=================

const tableObserver = new MutationObserver((mutations) => {
  for (const mutation of mutations) {
    if (mutation.type === 'childList') {
      for (const node of mutation.addedNodes) {
        if (node.nodeType === 1 && (node.id === 'download' || isCommunicationDrawer(node))) {
          setTimeout(() => injectPushButton(node), 300);
        }
      }
    }
  }
});
tableObserver.observe(document.body, { childList: true, subtree: true });

// ================= 确认弹窗 =================

function showConfirmDialog(data, onConfirm) {
  if (document.getElementById('dtss2002-modal')) return;
  const overlay = document.createElement('div');
  overlay.id = 'dtss2002-modal';
  Object.assign(overlay.style, {
    position: 'fixed', top: 0, left: 0, width: '100vw', height: '100vh',
    backgroundColor: 'rgba(0,0,0,0.5)', zIndex: 99999,
    display: 'flex', alignItems: 'center', justifyContent: 'center'
  });

  const modal = document.createElement('div');
  Object.assign(modal.style, {
    backgroundColor: 'white', padding: '20px', borderRadius: '8px',
    width: '500px', maxWidth: '90vw', maxHeight: '80vh', overflowY: 'auto',
    fontSize: '14px', boxShadow: '0 4px 12px rgba(0,0,0,0.3)'
  });

  modal.innerHTML = `
    <h3 style="margin-top:0; color:#1890ff;">📤 确认推送处理方案</h3>
    <p><strong>VIN:</strong> ${data.vin || '—'}</p>
    <p><strong>车牌:</strong> ${data.plate || '—'}</p>
    <p><strong>故障描述:</strong> ${data.faultDesc || '—'}</p>
    <p><strong>服务顾问:</strong> ${data.advisor || '—'}</p>
    <p><strong>原处理方案:</strong></p>
    <textarea id="dtss2002-edit-message" rows="4" style="width:100%; padding:6px; border:1px solid #ccc; border-radius:4px;">${data.selectedMessage}</textarea>
    <div style="margin-top:16px; text-align:right;">
      <button id="dtss2002-cancel" type="button" style="margin-right:8px; padding:4px 12px;">取消</button>
      <button id="dtss2002-confirm" type="button" style="background:#1890ff; color:white; border:none; padding:4px 12px; border-radius:4px;">确认推送</button>
    </div>
  `;

  overlay.appendChild(modal);
  document.body.appendChild(overlay);

  modal.querySelector('#dtss2002-cancel').onclick = () => document.body.removeChild(overlay);
  modal.querySelector('#dtss2002-confirm').onclick = () => {
    const editedMessage = modal.querySelector('#dtss2002-edit-message').value.trim();
    if (!editedMessage) {
      showTemporaryToast('⚠️ 处理方案不能为空', 'error');
      return;
    }
    document.body.removeChild(overlay);
    onConfirm(editedMessage);
  };
}

// ================= 核心：支持 SPA 路由跳转的初始化 =================

function mainInit() {
  //hasBoundListener = false;
  hasInjectedButton = false;

  document.querySelectorAll('[__dtssBound__], [__dtss2002_injected__]').forEach(el => {
    delete el.__dtssBound__;
    delete el.__dtss2002_injected__;
  });

  console.log('开始监听发送按键');
  startObserving();

  const existing = document.getElementById('download');
  if (existing) {
    injectPushButton(existing);
  }
}

// ✅ 修复：使用页面特征判断是否为 JDTSS 页面（不再依赖 URL）
function isJDTSSPage() {
  return !!(
    document.getElementById('download') ||                     // 交流历史抽屉
    document.querySelector('.el-drawer') ||                   // 抽屉组件
    document.querySelector('#bodyNr, #carnum, #khms, #scname') // 表单字段
  );
}

// 监听 SPA 路由变化
let currentUrl = window.location.href;

function onRouteChange() {
  const newUrl = window.location.href;
  if (newUrl !== currentUrl) {
    currentUrl = newUrl;
    if (isJDTSSPage()) {
      console.log('[JDTSS Plugin] 检测到路由变化，重新初始化...');
      setTimeout(mainInit, 300);
    }
  }
}

const originalPush = history.pushState;
const originalReplace = history.replaceState;

history.pushState = function() {
  originalPush.apply(this, arguments);
  onRouteChange();
};

history.replaceState = function() {
  originalReplace.apply(this, arguments);
  onRouteChange();
};

window.addEventListener('popstate', onRouteChange);

// ================= 启动 =================

function runWhenReady() {
  // ✅ 不再提前 return，确保在目标页面运行
  //if (!isJDTSSPage()) return; // ← 现在是安全的判断
  console.log('[JDTSS Plugin] 初始化...');
  mainInit();
}

if (document.readyState === 'loading') {
  document.addEventListener('DOMContentLoaded', runWhenReady);
} else {
  runWhenReady();
}